/***********************************************/
/*Negyedrendu Runga-Kutta modszer              */
/*az y'=f(y,t) differencialegyenlet megoldasara*/
/*y s y' n elemu vektor, t skalar             */
/***********************************************/
#include<stdlib.h>
#include<math.h>

extern double h;/*a t-beli lepeskoz*/

/*****************************************/
/*fuggvenymutato, visszateres: fyt=f(y,t)*/
/*****************************************/
extern void (*f)(double *y,double t,double *fyt);

/***************************************/
/*inicializalas, y0 n elemu kezdovektor*/
/*visszateres: 0, ha OK,               */
/*            -1, ha nincs eleg memoria*/
/***************************************/
int initrk(int ujn);

/************************/
/*memoria felszabaditasa*/
/************************/
void closerk();

/********************************/
/*egy lepes                     */
/*yn az y(t[n]),                */
/*visszateres: ynp1 az y(t[n+1])*/
/********************************/
void rk(double *yn, double tn, double *ynp1);

/******************************************/
/*egy lepes, yn az y(t[n]),                */
/*visszateres: ynp1 az y(t[n+1])          */
/*ha h*|f(yn,tn)|>0.1, uj h=0.1/|f(yn,tn|)*/
/*a visszateresi ertek a tenyleges h      */
/******************************************/
double rk2(double *yn, double tn, double *ynp1);

