/***********************************************/
/*Negyedrendu Runga-Kutta modszer              */
/*az y'=f(y,t) differencialegyenlet megoldasara*/
/*y es y' n elemu vektor, t skalar             */
/***********************************************/
#include<stdlib.h>
#include<math.h>

double h;/*a t-beli lepeskoz*/
static int n;/*y vektorok elemszama*/
static double *y, *k1,*k2,*k3,*k4;

/*****************************************/
/*fuggvenymutato, visszateres: fyt=f(y,t)*/
/*****************************************/
void (*f)(double *y,double t,double *fyt);

/***************************************/
/*inicializalas, y0 n elemu kezdovektor*/
/*visszateres: 0, ha OK,               */
/*            -1, ha nincs elel memoria*/
/***************************************/
int initrk(int ujn)
{int i;

 y=(double*)malloc(sizeof(double)*ujn);
  if(!y){return -1;}
 k1=(double*)malloc(sizeof(double)*ujn);
  if(!k1){return -1;}
 k2=(double*)malloc(sizeof(double)*ujn);
  if(!k2){return -1;}
 k3=(double*)malloc(sizeof(double)*ujn);
  if(!k3){return -1;}
 k4=(double*)malloc(sizeof(double)*ujn);
  if(!k4){return -1;}

 n=ujn;
 return 0;
}

/************************/
/*memoria felszabaditasa*/
/************************/
void closerk()
{n=0;
 free(k4);
 free(k3);
 free(k2);
 free(k1);
 free(y);
}

/********************************/
/*egy lepes                     */
/*yn az y(t[n]),                */
/*visszateres: ynp1 az y(t[n+1])*/
/********************************/
void rk(double *yn, double tn, double *ynp1)
{int i;

 f(yn,tn,k1);
 for(i=0;i<n;i++)
    {k1[i]*=h;
     y[i]=yn[i]+k1[i]*0.5;
    }
 f(y,tn+h*0.5,k2);
 for(i=0;i<n;i++)
    {k2[i]*=h;
     y[i]=yn[i]+k2[i]*0.5;
    }
 f(y,tn+h*0.5,k3);
 for(i=0;i<n;i++)
    {k3[i]*=h;
     y[i]=yn[i]+k3[i];
    }
 f(y,tn+h,k4);
 for(i=0;i<n;i++)
    {k4[i]*=h;
     ynp1[i]=yn[i]+(k1[i]+2*k2[i]+2*k3[i]+k4[i])/6.0;
    }
}

/******************************************/
/*egy lepes, yn az y(t[n]),                */
/*visszateres: ynp1 az y(t[n+1])          */
/*ha h*|f(yn,tn)|>0.1, uj h=0.1/|f(yn,tn|)*/
/*a visszateresi ertek a tenyleges h      */
/******************************************/
double rk2(double *yn, double tn, double *ynp1)
{int i;
 double h2,norm;

 h2=h;
 /* h ellenorzese */
 f(yn,tn,k1);
 norm=0.0;
 for(i=0;i<n;i++)
    {norm+=k1[i]*k1[i];}
 if( (h*h*norm)>0.01 )
   {h2=0.1/sqrt(norm);
   }
 /* szamolas */
 for(i=0;i<n;i++)
    {k1[i]*=h2;
     y[i]=yn[i]+k1[i]*0.5;
    }
 f(y,tn+h2*0.5,k2);
 for(i=0;i<n;i++)
    {k2[i]*=h2;
     y[i]=yn[i]+k2[i]*0.5;
    }
 f(y,tn+h2*0.5,k3);
 for(i=0;i<n;i++)
    {k3[i]*=h2;
     y[i]=yn[i]+k3[i];
    }
 f(y,tn+h2,k4);
 for(i=0;i<n;i++)
    {k4[i]*=h2;
     ynp1[i]=yn[i]+(k1[i]+2*k2[i]+2*k3[i]+k4[i])/6.0;
    }
 return h;
}
