/*
  PhasePictor - A program for displaying phaseplane of an ODE
  Copyright (c) 2007-2009 Kristóf Kály-Kullai
  This program is free software, it is distributed under the terms 
  of the GNU General Public License version 3 or (at your option) later.
  For details see the attached GPL-3.txt file.
  The software is provided "AS IS", WITHOUT WARRANTY of any kind.
*/

/*DEFINICIOK*/
#if !defined(mateklib)
 #define mateklib

#include <math.h>
#define PI 3.14159265358979323846
#define MAX_VALT 256

typedef struct Valtozo{
               double ertek;
               char *nev;
              }valtozo;

typedef struct fuggveny{
               char *nev;
               double (*func)(double x);
               unsigned short int prec;
              }fgv;

typedef struct Elem{
               int valtozo;
               unsigned short int muvelet;
               double szam;
               struct Elem *kov;
               struct Elem *ala;
              }elem;

/*GLOBALIS VALTOZOK*/
extern valtozo valtozok[MAX_VALT];
extern fgv funcs[256];
extern double pi;
int materrno;
			  
/*MACROS*/
#define MAXIMUM(a,b) ( (a) > (b) ? (a) : (b) )
#define MINIMUM(a,b) ( (a) < (b) ? (a) : (b) )
#define SQR(a) ((a)*(a))

/*FUGGVENYEK*/
//*long int round(double f);*/

double actg(double x);

double arsh(double x);

double arch(double x);

double arth(double x);

double arcth(double x);

double ctg(double x);

double cth(double x);

/*heavyside*/
double theta(double x);

/*standard non linearity*/
double snl(double x);

void initmat();

/************************************************************/
/*reads the string in keplet to a list of elems             */
/*return: on normal return the number of read characters    */
/*on error -(the number of characters read before the error)*/
/************************************************************/
int olvas(char *keplet,elem *(*kelemp));

/****************************************/
/*evaluates the formula given in kkezd  */
/*returns on success with the value,    */
/*on error with 0.0, and materrno is set*/
/****************************************/
double ertekel(elem *kkezd);

void torol(elem *kkezd);

/***************************************/
/*writes keplet to a string            */
/*return: number of characters written,*/
/*or a negative value on error         */
/***************************************/
int kiir(elem *kkezd, char *keplet);

/*********************************************************/
/*returns 1, if the formula in kkezd depends on variable,*/
/*        0 otherwise                                    */
/*********************************************************/
int depends(elem *kkezd, int variable);

/********************************************************************/
/*Lagrange interpolacios polinom illesztese                         */
/*n pontra, xn: x alappontok, yn az ezeken felvett ertekek          */
/*visszateres: poli-ban a polinom egyutthatoi: poli[0]+poli[1]*x+...*/
/********************************************************************/
void lagrangepoli(int n,double *xn,double *yn,double *poli);

/************************************************************************/
/*n valtozos fuggveny feltetel nelkuli lokalis minimumanak meghatarozasa*/
/*flexibilis polieder modszerrel                                        */
/*parameterek: - f a fuggveny, f(hely) tipusu hivasai lesznek           */
/*             - n a valtozok szama                                     */
/*             - hely egy n dim. vektor, az eljaras kezdopontja         */
/*             - epszilon az az ertek, amekkora elteres lesz az egyes   */
/*               pontokon felvett fuggvenyertekekben                    */
/*             - maxit iteracio utan visszater a fuggveny a minimum     */
/*               aktualis kozelitesevel                                 */
/*visszateres: a minimumhely hibajaval (a minimumhely egy ekkora sugaru)*/
/*               gombben talalhato hely korul)                          */
/*             es helyben a minimumhely koordinatai lesznek             */
/*             visszateres=-100.0 => nincs eleg memoria                 */
/*                                                                      */
/*vagy: - initmin inicializalja                                         */
/*        visszateres: =-1 => nincs eleg memoria, =0 siker eseten       */
/*      - itermin egy iteracios lepest hajt vegre, visszater a lepes    */
/*        utan hibaval (hiba leirasat lasd fent), minhelybe rakja a     */
/*        minimumhely aktualis kozeliteset                              */
/*      - closemin felszabaditja a memoriat                             */
/************************************************************************/
extern double *minhely;

double minimum(double (*f)(double*), int n, double *hely, double epszilon, long int maxlep);

/***************/
/*inicializalas*/
/***************/
int initmin(double (*af)(double*), int an, double *hely);

/*********************/
/*egy iteracios lepes*/
/*********************/
double itermin();

/***********************/
/*memoria felszabaditas*/
/***********************/
void closemin();


/**********************************/
/*4th order Runge-Kutta method    */
/*numerically integrates y'=f(y,t)*/
/*y and y' have n elements        */
/**********************************/
/*function for evaluation       */
/*have to return with fyt=f(y,t)*/
/*0 on success, nonzero on error*/
typedef int (*rk_f)(double *y,double t,double *fyt);
typedef struct rk_struct
               {int n; /*dimension of y*/
                double *y, *k1,*k2,*k3,*k4, *finey;
                /*pointer to a function, it should return fyt=f(y,t)*/
                rk_f f;
               }rk_t;

/***************************************/
/*creates an rk_t structure            */
/*return: NULL on error                */
/*   pointer to the new rk_t on success*/
/***************************************/
rk_t* rk_create(int dimension);

/***************************************/
/*removes from memory an rk_t structure*/
/***************************************/
void rk_destroy(rk_t *rk);

/****************************/
/*get and set the f function*/
/****************************/
rk_f rk_get_function(rk_t *rk);

void rk_set_function(rk_t *rk, rk_f new_function);

/*********************************/
/*one iteration step             */
/*yn=y(tn), tn is the actual time*/
/*dt is the time step            */
/*return: ynp1=y(tn+dt), and     */
/*zero on success, !=0 on error  */
/*********************************/
int rk_iteration(rk_t *rk, double *yn, double tn, double dt, double *ynp1);

int rk_iteration_finestep(rk_t *rk, double *yn, double tn, double dt, double *ynp1);

#endif
