/*
  PhasePictor - A program for displaying phaseplane of an ODE
  Copyright (c) 2007-2009 Kristóf Kály-Kullai
  This program is free software, it is distributed under the terms 
  of the GNU General Public License version 3 or (at your option) later.
  For details see the attached GPL-3.txt file.
  The software is provided "AS IS", WITHOUT WARRANTY of any kind.
*/
#include <stdio.h>
#include <errno.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "mateklib.h"

/*DEFINICIOK*/
#define EPSILON 1e-36

/*GLOBALIS VALTOZOK*/
valtozo valtozok[MAX_VALT];
fgv funcs[256];
double pi=3.1415926535897932384626433832795;
int materrno;
char emptyname[1]={0};

/*FUGGVENYEK*/
/*long int round(double f)
{long int a;
 if(f<0)f-=1.0;
 a=(long int)(f+0.5);
 return(a);
}*/

double actg(double x)
{return((pi/2)-atan(x));}

double arsh(double x)
{return( log(x+sqrt(x*x+1)) );}

double arch(double x)
{return( log(x+sqrt(x*x-1)) );}

double arth(double x)
{return( 0.5*log((1+x)/(1-x)) );}

double arcth(double x)
{return( 0.5*log((x+1)/(x-1)) );}

double ctg(double x)
{return( tan(pi/2-x) );}

double cth(double x)
{return( (exp(x)+exp(-x))/(exp(x)-exp(-x)) );}

/*heavyside*/
double theta(double x)
{if(x>=0)return 1;
  else return 0;
}

/*standard non linearity*/
double snl(double x)
{if(x>0.5){return 0.5;}
   else if(x>-0.5){return x;}
          else{return -0.5;}
}

void initmat()
{int i;

 valtozok[0].nev="pi"; valtozok[0].ertek=pi;
 for(i=1;i<MAX_VALT;i++)
    {valtozok[i].nev=emptyname;
     valtozok[i].ertek=0.0;
    }
 for(i=0;i<256;i++)
    {/*for(j=0;j<5;j++)*/funcs[i].nev="";
     funcs[i].func=NULL;
     funcs[i].prec=0;
    }
 funcs[0].prec=10;
 funcs[1].nev="+"; funcs[1].prec=0;
 funcs[2].nev="-"; funcs[2].prec=0;
 funcs[3].nev="*"; funcs[3].prec=1;
 funcs[4].nev="/"; funcs[4].prec=1;
 funcs[5].nev="^"; funcs[5].prec=2;
 for(i=11;i<=31;i++)funcs[i].prec=3;
 funcs[11].nev="abs"; funcs[11].func=fabs;
 funcs[12].nev="acos"; funcs[12].func=acos;
 funcs[13].nev="asin"; funcs[13].func=asin;
 funcs[14].nev="atan"; funcs[14].func=atan;
 funcs[15].nev="actg"; funcs[15].func=actg;
 funcs[16].nev="arsh"; funcs[16].func=arsh;
 funcs[17].nev="arch"; funcs[17].func=arch;
 funcs[18].nev="arth"; funcs[18].func=arth;
 funcs[19].nev="arcth"; funcs[19].func=arcth;
 funcs[20].nev="cos"; funcs[20].func=cos;
 funcs[21].nev="sin"; funcs[21].func=sin;
 funcs[22].nev="tan"; funcs[22].func=tan;
 funcs[23].nev="ctg"; funcs[23].func=ctg;
 funcs[24].nev="ch"; funcs[24].func=cosh;
 funcs[25].nev="sh"; funcs[25].func=sinh;
 funcs[26].nev="th"; funcs[26].func=tanh;
 funcs[27].nev="cth"; funcs[27].func=cth;
 funcs[28].nev="exp"; funcs[28].func=exp;
 funcs[29].nev="ln"; funcs[29].func=log;
 funcs[30].nev="log"; funcs[30].func=log10;
 funcs[31].nev="sqrt"; funcs[31].func=sqrt;
 funcs[32].nev="theta"; funcs[32].func=theta;
 funcs[33].nev="snl"; funcs[33].func=snl;
}

/************************************************************/
/*reads the string in keplet to a list of elems             */
/*return: on normal return the number of read characters    */
/*on error -(the number of characters read before the error)*/
/************************************************************/
int olvas(char *keplet,elem *(*kelemp))
{char astr[33]="",ak,mstr[]="+-*/^";
 int poz;
 int spoz, ok, ala=0;
 int i;
 elem *aelem,*belem,*celem,*kelem,*precp[3];
 double szam;

 if(!(keplet[0])){return(0);}
 for(spoz=0;spoz<33;spoz++){astr[spoz]=0;}
 poz=-1; spoz=0;
 kelem=(elem*)malloc(sizeof(elem));
  kelem->valtozo=-1; kelem->muvelet=0;
  kelem->szam=0.0;
  kelem->kov=NULL; kelem->ala=NULL;
 *kelemp=kelem;
 aelem=kelem;
 ok=0;
 for(i=0;i<3;i++){precp[i]=/*aelem*/NULL;}
 do
    {poz++;
     ak=keplet[poz];
     if( (ak=='(')||(ak==')')||(ak=='+')||(ak=='-')||(ak=='*')||(ak=='/')
       ||(ak=='^')||(ak=='\x0') )
         {switch(ak)
            {case '(':{/*rekurzio*/
                       ok=0;
                       if(astr[0])
                         {/*check if it is a function call*/
                          for(i=0;i<=255;i++)
                             {if( !( strcmp(astr,funcs[i].nev) ) )
                                {ok=1;
                                 if(aelem->muvelet)
                                   {belem=(elem*)malloc(sizeof(elem));
                                     belem->valtozo=-1; belem->muvelet=0;
                                     belem->szam=0.0;
                                     belem->kov=NULL; belem->ala=NULL;
                                     aelem->ala=belem;
                                     aelem=belem;
                                    }
                                 aelem->muvelet=i;
                                 break;
                                }
                             }
                         }
                       else
                         {/*check if it is the first character*/
                          if(poz==0){ok=1;}
                           /*or if an operation before '('*/
                           else if( strchr(mstr,keplet[poz-1]) ){ok=1;}
                         }
                       /*return with error*/
                       if(!ok){return -poz;}
                       /*now do the recursion*/
                       i=olvas(&keplet[poz+1],&aelem->ala);
                       /*error in recursion*/
                       if(i<=0){return -poz-1+i;}
                       /*error if no ')' found for '('*/
                       poz+=i+1;
                       if( keplet[poz]!=')' )
                         {return -poz;}
                       /*egyszerusites*/
                       if( (aelem->ala->ala==NULL)&&(aelem->ala->kov==NULL)
                         &&(aelem->ala->muvelet==0) )
                         {aelem->valtozo=aelem->ala->valtozo;
                          aelem->szam=aelem->ala->szam;
                          free(aelem->ala);
                          aelem->ala=NULL;
                         }
                       break;}
             case ')':{/*error if nothing reasonable before ')'*/
                       if(poz==0){return 0;}
                       if(keplet[poz-1]==')'){return poz;}/*fast return here with OK*/
                        else if(!astr[0]){return -poz;}
                       ok=0;
                       /*check if a number is before*/
                       if( (sscanf(astr,"%lf",&szam))==1 )
                         {aelem->szam=szam; ok=1;
                         }
                       /*check if a variable is before*/
                       if( (!ok)&&(astr[0]) )
                         {for(i=0;i<MAX_VALT;i++)
                             {if( !( strcmp(astr,valtozok[i].nev) ) )
                                {aelem->valtozo=i; ok=1;
                                 break;
                                }
                             }
                         }
                       /*returning with error or with OK status*/
                       if(!ok){return -poz;}
                        else{return poz;}
                       break;}
             case '-':{/*if keplet starts with a '-'*/
                       if(poz==0)
                         {aelem->muvelet=2;
                          break;
                         }
                       if( (keplet[poz-1]=='e') || (keplet[poz-1]=='E') )
                         {if(poz>=2)
                            if(isdigit(keplet[poz-2]))
                              {if(astr[0])
                                 {ok=0;
                                  for(i=0;i<MAX_VALT;i++)
                                     {if( !( strcmp(astr,valtozok[i].nev) ) )
                                        {ok=1;
                                         break;
                                        }
                                     }
                                 }
                               if( (!ok) && (isdigit(keplet[poz+1])) )
                                 {astr[spoz]=ak;
                                  spoz++;
                                  continue;/*continue with next iteration of do..while*/
                                 }
                              }
                            if( (isdigit(keplet[poz+1]))&&(isdigit(keplet[poz-2])) )
                              {astr[spoz]=ak;
                               spoz++;
                               continue;/*continue with next iteration of do..while*/
                              }
                          }
                      }
             default:{/*error if nothing reasonable before ')'*/
                      if(poz==0){return 0;}
                      if( (!astr[0]) && (keplet[poz-1]!=')') )
                        {return -poz;}
                      ok=0;
                      /*check if a number is before*/
                      if( (sscanf(astr,"%lf",&szam))==1 )
                        {aelem->szam=szam; ok=1;
                        }
                      /*check if a variable is before*/
                      if( (!ok)&&(astr[0]) )
                        {for(i=0;i<MAX_VALT;i++)
                            {if( !( strcmp(astr,valtozok[i].nev) ) )
                               {aelem->valtozo=i; ok=1;
                                break;
                               }
                            }
                        }
                      /*return with error if nothing reasonable found*/
                      if( (!ok)&&(keplet[poz-1]!=')') ){return -poz;}
                      /*return if end of string*/
                      if(ak==0){return poz;}
                      /*create new elem if everything OK*/
                      belem=(elem*)malloc(sizeof(elem));
                       belem->valtozo=-1; belem->muvelet=0;
                       belem->szam=0.0;
                       belem->kov=NULL; belem->ala=NULL;
                      switch(ak)
                        {case '+':belem->muvelet=1;
                                  break;
                         case '-':belem->muvelet=2;
                                  break;
                         case '*':belem->muvelet=3;
                                  break;
                         case '/':belem->muvelet=4;
                                  break;
                         case '^':belem->muvelet=5;
                        }
                      /*dealing with precedency*/
                      if(funcs[belem->muvelet].prec>funcs[aelem->muvelet].prec)
                          {celem=(elem*)malloc(sizeof(elem));
                            celem->muvelet=0;
                            celem->valtozo=aelem->valtozo;
                            celem->szam=aelem->szam;
                            celem->ala=aelem->ala;
                            celem->kov=aelem->kov;
                           aelem->valtozo=-1;
                           aelem->szam=0.0;
                           aelem->kov=NULL;
                           aelem->ala=celem;
                           ala=funcs[belem->muvelet].prec-funcs[aelem->muvelet].prec;
                           for(i=0;i<funcs[belem->muvelet].prec;i++)
                              {if(precp[i]==NULL)
                                 {precp[i]=aelem;}
                              }
                           aelem=celem;
                          }
                      if( (aelem->muvelet)&&
                         (funcs[belem->muvelet].prec<=funcs[aelem->muvelet].prec) )
                        {if( precp[funcs[belem->muvelet].prec] )
                           {aelem=precp[funcs[belem->muvelet].prec];}
                         /*for(i=funcs[belem->muvelet].prec;i<3;i++)
                            {precp[i]=aelem;}*/
                        }
                      aelem->kov=belem;
                      aelem=belem;
                      for(i=funcs[belem->muvelet].prec;i<3;i++)
                         {precp[i]=aelem;
                         }
                      if(ala==2)
                        {ala=0;
                         precp[1]=aelem;
                        }
/*                      for(i=0;i<funcs[belem->muvelet].prec;i++)
                         {if(precp[i]==kelem){precp[i]=aelem;}
                         }*/
                     }
             }
          for(i=0;i<=spoz;i++)astr[i]=0;
          spoz=0;
         }
     else{astr[spoz]=ak;
          spoz++;
         }
    }while(keplet[poz]);
 return poz;
}

/****************************************/
/*evaluates the formula given in kkezd  */
/*returns on success with the value,    */
/*on error with 0.0, and materrno is set*/
/****************************************/
double ertekel(elem *kkezd)
{double eredmeny,sv;
 elem *fp;

 materrno=0;
 errno=0;
 fp=kkezd;
 eredmeny=0.0;
/* if(fp->valtozo)
   {eredmeny=valtozok[fp->valtozo].ertek;}
 else if(fp->ala){eredmeny=ertekel(fp->ala);}
      else{eredmeny=fp->szam;}
 fp=fp->kov;*/
 while(fp!=NULL)
   {if(fp->valtozo>=0)
      {sv=valtozok[fp->valtozo].ertek;}
    else{if(fp->ala!=NULL){sv=ertekel(fp->ala);}
         else{sv=fp->szam;}
        }
    if(errno)
      {materrno=errno;
       return(0.0);
      }
    switch(fp->muvelet)
      {case 0:eredmeny=sv;
              break;
       case 1:eredmeny+=sv;
              break;
       case 2:eredmeny-=sv;
              break;
       case 3:eredmeny*=sv;
              break;
       case 4:eredmeny/=sv;
              break;
       case 5:eredmeny=pow(eredmeny,sv);
              break;
       default:eredmeny=(*(funcs[fp->muvelet].func))(sv);
      }
    if(errno)
      {materrno=errno;
       return(0.0);
      }
    fp=fp->kov;
   }
 return eredmeny;
}

void torol(elem *kkezd)
{elem *fp, *ap;

 fp=kkezd;
 while(fp!=NULL)
   {if(fp->ala)
      {torol(fp->ala);}
    ap=fp;
    fp=fp->kov;
    free(ap);
   }
}

/***************************************/
/*writes keplet to a string            */
/*return: number of characters written,*/
/*or a negative value on error         */
/***************************************/
int kiir(elem *kkezd, char *keplet)
{int poz, i, bracket;
 unsigned short int minprec;
 elem *fp, *gp;

 if( (kkezd==NULL)||(keplet==NULL) ){return -1;}
 fp=kkezd;
 poz=0;
 bracket=0;
 minprec=3;
 while(fp!=NULL)
    {if(fp->muvelet)
       {i=sprintf(keplet+poz,"%s",funcs[fp->muvelet].nev);
        if(i<0){return i;}
        poz+=i;
       }
     if(fp->valtozo>=0)
       {i=sprintf(keplet+poz,"%s",valtozok[fp->valtozo].nev);
        if(i<0){return i;}
        poz+=i;
       }
     else
       {if(fp->ala!=NULL)
          {/*check if a bracket is required, 
             that is if lower precedency occurs in ala than fp's precedency*/
           if(funcs[fp->muvelet].prec==3){bracket=1;}
           else
             {gp=fp->ala;
              minprec=3;
              while(gp)
                 {minprec=MINIMUM(funcs[gp->muvelet].prec,minprec);
                  if(minprec==0){break;}
                  gp=gp->kov;
                 }
              if(funcs[fp->muvelet].prec>minprec){bracket=1;}
               else{bracket=0;}
             }
           if(bracket)
             {i=sprintf(keplet+poz,"(");
              if(i<0){return i;}
              poz+=i;
             }
           i=kiir(fp->ala,keplet+poz);
           if(i<0){return i;}
           poz+=i;
           if(bracket)
             {i=sprintf(keplet+poz,")");
              if(i<0){return i;}
              poz+=i;
             }
          }
        else
          {i=sprintf(keplet+poz,"%g",fp->szam);
           if(i<0){return i;}
           poz+=i;
          }
       }
     fp=fp->kov;
    }
 return poz;
}

/*********************************************************/
/*returns 1, if the formula in kkezd depends on variable,*/
/*        0 otherwise                                    */
/*********************************************************/
int depends(elem *kkezd, int variable)
{elem *fp;
 
 fp=kkezd;
 while(fp)
    {if(fp->valtozo==variable){return 1;}
     if(fp->ala)
       if( depends(fp->ala, variable) ){return 1;}
     fp=fp->kov;
    }
 return 0;
}

/********************************************************************/
/*Lagrange interpolacios polinom illesztese                         */
/*n pontra, xn: x alappontok, yn az ezeken felvett ertekek          */
/*visszateres: poli-ban a polinom egyutthatoi: poli[0]+poli[1]*x+...*/
/********************************************************************/
void lagrangepoli(int n,double *xn,double *yn,double *poli)
{double *xa;
 double konst, prod,sum;
 int i,j,k,l,m,o;
 int *iv;

 if(n<1){return;}
 if(n==1)
   {poli[0]=yn[0];
    return;
   }
 /* inicializalas */
 xa=(double*)malloc((n)*sizeof(double));
 iv=(int*)malloc((n)*sizeof(int));
 for(i=0;i<n;i++)
    {poli[i]=0.0;}
 for(i=0;i<n-1;i++)
    {xa[i]=xn[i+1];
    }
 /* i: alappolinmok szummazasa */
 for(i=0;i<n;i++)
    {/* alappolinom konstans szorzoja=yn/nevezo */
     konst=1;
     for(j=0;j<n-1;j++)
        {konst*=(xn[i]-xa[j]);
        }
     if(konst==0)
         {return;}
     else{konst=yn[i]/konst;}
     /* x^(n-1) egyutthatoja a szamlaloban 1*/
     poli[n-1]+=konst;
     /* x^(n-2) egyutthatoja */
     sum=0;
     for(l=0;l<n-1;l++)
        {sum+=(-xa[l]);}
     poli[n-2]+=konst*sum;
     /* x^(n-1-k) egyutthatoja */
     for(k=2;k<n;k++)
        /* n-1 tagbol minden lehetseges k tag kivalasztasa es osszeszorzasa */
        {for(l=0;l<k;l++)
            {iv[l]=l;}
         sum=0; /* sum lesz az x^(n-1-k) tag egyutthatoja a szamlaloban*/
         while(iv[k-1]!=n-1)
           {for(l=1;l<k;l++)
               {if((iv[l]-iv[l-1])>1)
                  {/* prod: az adott kombinacio jaruleka */
                   prod=1;
                   for(o=0;o<k;o++)
                      {prod*=(-xa[iv[o]]);}
                   sum+=prod;
                   /* a kovetkezo kombinacio eloallitasa: */
                   iv[l-1]++;
                   for(m=0;m<l-1;m++)
                      {iv[m]=m;}
                   break;
                  }
               }
            /* utolso elem leptetese */
            if(l==k)
              {prod=1;
               for(o=0;o<k;o++)
                  {prod*=(-xa[iv[o]]);}
               sum+=prod;
               iv[k-1]++;
               for(m=0;m<k-1;m++)
                  {iv[m]=m;}
              }
           }
         /* egyutthato beirasa*/
         poli[n-1-k]+=konst*sum;
        }
     /* xa leptetese */
     xa[i]=xn[i];
    }
 free(iv); free(xa);
}

/************************************************************************/
/*n valtozos fuggveny feltetel nelkuli lokalis minimumanak meghatarozasa*/
/*flexibilis polieder modszerrel                                        */
/*parameterek: - f a fuggveny, f(hely) tipusu hivasai lesznek           */
/*             - n a valtozok szama                                     */
/*             - hely egy n dim. vektor, az eljaras kezdopontja         */
/*             - epszilon az az ertek, amekkora elteres lesz az egyes   */
/*               pontokon felvett fuggvenyertekekben                    */
/*             - maxit iteracio utan visszater a fuggveny a minimum     */
/*               aktualis kozelitesevel                                 */
/*visszateres: a minimumhely hibajaval (a minimumhely egy ekkora sugaru)*/
/*               gombben talalhato hely korul)                          */
/*             es helyben a minimumhely koordinatai lesznek             */
/*             visszateres=-100.0 => nincs eleg memoria                 */
/*                                                                      */
/*vagy: - initmin inicializalja                                         */
/*        visszateres: =-1 => nincs eleg memoria, =0 siker eseten       */
/*      - itermin egy iteracios lepest hajt vegre, visszater a lepes    */
/*        utan hibaval (hiba leirasat lasd fent), minhelybe rakja a     */
/*        minimumhely aktualis kozeliteset                              */
/*      - closemin felszabaditja a memoriat                             */
/************************************************************************/
double *minhely;
static double **x;
static double (*f)(double*);
static int n;

double minimum(double (*f)(double*), int n, double *hely, double epszilon, long int maxlep)
{double R=1.0, alfa=1.0,beta=0.5,gamma=2.0;
 double t2,a,b;
 double elteres, hiba;
 int i,j,k, h,l, lepesszam;
 short int komp;

 x=(double**)calloc(n+6,sizeof(double**));
 if(x==NULL)return -100.0;
 for(i=1;i<=n+6;i++)
    {x[i]=(double*)calloc(n+1,sizeof(double));
     if(x[i]==NULL)return-100.0;
    }
 /*kezdo n dim. "tetraeder" hely korul*/
 x[1][1]=R; x[2][1]=-R; t2=4*R*R;
 for(i=2;i<=n;i++)
    {b=R*(t2-2)/t2;
     a=sqrt(R*R-b*b);
     t2=t2*a*a;
     for(j=1;j<=i;j++)
        {for(k=1;k<=(i-1);k++){x[j][k]*=a;}
         x[j][i]=-b;
        }
         for(k=1;k<=(i-1);k++){x[i+1][k]=0;}
         x[i+1][i]=1;
    }
 for(j=1;j<=n+1;j++)
    for(k=1;k<=n;k++){x[j][k]+=hely[k-1];}
 /*iteralas*/
 elteres=epszilon+1.0;
 lepesszam=0;
 h=1;
 while(elteres>epszilon)
   {/*fuggvenyertekek x[i][0]-kbe*/
    for(i=1;i<=n+1;i++)
       {x[i][0]=f( &(x[i][1]) );}
    /*x[l], x[h] keresese*/
    l=1; h=1;
    for(i=1;i<=n+1;i++)
       {if( x[i][0]<x[l][0] )l=i;
        if( x[i][0]>x[h][0] )h=i;
       }
    /*x[n+2] szamolasa*/
    for(k=1;k<=n;k++)x[n+2][k]=0.0;
    for(k=1;k<=n;k++)
       {for(i=1;i<=n+1;i++)
           {x[n+2][k]+=x[i][k];}
        x[n+2][k]-=x[h][k];
        x[n+2][k]/=((double)n);
       }
    x[n+2][0]=f( &(x[n+2][1]) );
    /*tukrozes vagy reflexio*/
    for(k=1;k<=n;k++){x[n+3][k]=x[n+2][k]+alfa*(x[n+2][k]-x[h][k]);}
    x[n+3][0]=f( &(x[n+3][1]) );
    if( (x[l][0]<=x[n+3][0])&&(x[n+3][0]<x[h][0]) )
      {for(k=0;k<=n;k++){x[h][k]=x[n+3][k];}
       goto itveg;
      }
    /*bovites vagy expanzio*/
    if( x[n+3][0]<x[l][0] )
        {for(k=1;k<=n;k++){x[n+4][k]=x[n+2][k]+gamma*(x[n+3][k]-x[n+2][k]);}
         x[n+4][0]=f( &(x[n+4][1]) );
         if( x[n+4][0]<x[l][0] )
             {for(k=0;k<=n;k++){x[h][k]=x[n+4][k];}
             }
         else{for(k=0;k<=n;k++){x[h][k]=x[n+3][k];}
             }
         /*goto itveg;*/
        }
    else{/*zsugoritas vagy kompresszio*/
         komp=1;
         for(i=1;i<=n+1;i++)
            {if(i!=h)
               {if( x[n+3][0]<x[i][0] )komp=0;}
            }
         if(komp)
             {if( x[n+3][0]<x[h][0] )
                for(k=0;k<=n;k++){x[h][k]=x[n+3][k];}
              for(k=1;k<=n;k++)x[n+5][k]=x[n+2][k]+beta*(x[h][k]-x[n+2][k]);
              x[n+5][0]=f( &(x[n+5][1]) );
              if( x[n+5][0]<x[h][0] )
                  {for(k=0;k<=n;k++){x[h][k]=x[n+5][k];}
                  }
              else{/*kicsinyites vagy redukcio*/
                   for(i=1;i<=n+1;i++)
                      for(k=1;k<=n;k++)x[i][k]=x[l][k]+0.5*(x[i][k]-x[l][k]);
                  }
             }
         else{for(k=0;k<=n;k++){x[h][k]=x[n+3][k];}
              /*goto itveg;*/
             }
        }
    itveg: ;
      lepesszam++;
      elteres=0;
      for(i=1;i<=n+1;i++)
         {elteres+=(x[i][0]-x[n+2][0])*(x[i][0]-x[n+2][0]);
         }
      elteres=sqrt( elteres/( ((double)n)+1 ) );
    if( lepesszam>maxlep )break;
   }/*while(elteres>epszilon) vege*/
 /*uj x[n+2]*/
 for(k=1;k<=n;k++)x[n+2][k]=0.0;
  for(k=1;k<=n;k++)
     {for(i=1;i<=n+1;i++)
         {x[n+2][k]+=x[i][k];}
      x[n+2][k]-=x[h][k];
      x[n+2][k]/=((double)n);
     }
  x[n+2][0]=f( &(x[n+2][1]) );
 /*x[l] keresese*/
 for(i=1;i<=n+2;i++)
       {x[i][0]=f( &(x[i][1]) );}
    l=1;
    for(i=1;i<=n+2;i++)
       {if( x[i][0]<x[l][0] )l=i;}
 /*hibabecsles: x[l] koruli gomb sugara, amiben minden x[i] benne van*/
 hiba=0.0;
 for(i=1;i<=n+2;i++)
    {t2=0;
     for(k=1;k<=n;k++)t2+=(x[l][k]-x[i][k])*(x[l][k]-x[i][k]);
     if(t2>hiba)hiba=t2;
    }
 hiba=sqrt(hiba);
 for(k=1;k<=n;k++)hely[k-1]=x[l][k];
 for(i=1;i<=n+6;i++)free(x[i]);
 free(x);
 return hiba;
}

/***************/
/*inicializalas*/
/***************/
int initmin(double (*af)(double*), int an, double *hely)
{int i,j,k;
 double R=1.0,t2,a,b;
 double R0=0.01;

 f=af;
 n=an;
 x=(double**)calloc(n+6,sizeof(double**));
 if(x==NULL)return -1;
 for(i=1;i<=n+6;i++)
    {x[i]=(double*)calloc(n+1,sizeof(double));
     if(x[i]==NULL)return -1;
    }
 minhely=(double*)calloc(n+1,sizeof(double));
 /*kezdo n dim. "tetraeder" hely korul*/
 x[1][1]=R; x[2][1]=-R; t2=4*R*R;
 for(i=2;i<=n;i++)
    {b=R*(t2-2)/t2;
     a=sqrt(R*R-b*b);
     t2=t2*a*a;
     for(j=1;j<=i;j++)
        {for(k=1;k<=(i-1);k++){x[j][k]*=a;}
         x[j][i]=-b;
        }
         for(k=1;k<=(i-1);k++){x[i+1][k]=0;}
         x[i+1][i]=1;
    }
 for(j=1;j<=n+1;j++)
    {for(k=1;k<=n;k++)
        {x[j][k]*=R0;
         x[j][k]+=hely[k-1];
        }
    }
 return 0;
}

/*********************/
/*egy iteracios lepes*/
/*********************/
double itermin()
{int i,k,h,l;
 double alfa=1.0,beta=0.5,gamma=2.0;
 double hiba,t2;
 short int komp;

 /*fuggvenyertekek x[i][0]-kbe*/
 for(i=1;i<=n+1;i++)
    {x[i][0]=f( &(x[i][1]) );}
 /*x[l], x[h] keresese*/
 l=1; h=1;
 for(i=1;i<=n+1;i++)
    {if( x[i][0]<x[l][0] )l=i;
     if( x[i][0]>x[h][0] )h=i;
    }
 /*x[n+2] szamolasa*/
 for(k=1;k<=n;k++)x[n+2][k]=0.0;
 for(k=1;k<=n;k++)
    {for(i=1;i<=n+1;i++)
        {x[n+2][k]+=x[i][k];}
     x[n+2][k]-=x[h][k];
     x[n+2][k]/=((double)n);
    }
 x[n+2][0]=f( &(x[n+2][1]) );
 /*tukrozes vagy reflexio*/
 for(k=1;k<=n;k++){x[n+3][k]=x[n+2][k]+alfa*(x[n+2][k]-x[h][k]);}
 x[n+3][0]=f( &(x[n+3][1]) );
 if( (x[l][0]<=x[n+3][0])&&(x[n+3][0]<x[h][0]) )
   {for(k=0;k<=n;k++){x[h][k]=x[n+3][k];}
    goto itveg;
   }
 /*bovites vagy expanzio*/
 if( x[n+3][0]<x[l][0] )
     {for(k=1;k<=n;k++){x[n+4][k]=x[n+2][k]+gamma*(x[n+3][k]-x[n+2][k]);}
      x[n+4][0]=f( &(x[n+4][1]) );
      if( x[n+4][0]<x[l][0] )
          {for(k=0;k<=n;k++){x[h][k]=x[n+4][k];}
          }
      else{for(k=0;k<=n;k++){x[h][k]=x[n+3][k];}
          }
      /*goto itveg;*/
     }
 else{/*zsugoritas vagy kompresszio*/
      komp=1;
      for(i=1;i<=n+1;i++)
         {if(i!=h)
            {if( x[n+3][0]<x[i][0] )komp=0;}
         }
      if(komp)
          {if( x[n+3][0]<x[h][0] )
             for(k=0;k<=n;k++){x[h][k]=x[n+3][k];}
           for(k=1;k<=n;k++)x[n+5][k]=x[n+2][k]+beta*(x[h][k]-x[n+2][k]);
           x[n+5][0]=f( &(x[n+5][1]) );
           if( x[n+5][0]<x[h][0] )
               {for(k=0;k<=n;k++){x[h][k]=x[n+5][k];}
               }
           else{/*kicsinyites vagy redukcio*/
                for(i=1;i<=n+1;i++)
                for(k=1;k<=n;k++)x[i][k]=x[l][k]+0.5*(x[i][k]-x[l][k]);
               }
          }
      else{for(k=0;k<=n;k++){x[h][k]=x[n+3][k];}
              /*goto itveg;*/
          }
     }

 itveg: ;

 /*uj x[n+2]*/
 for(k=1;k<=n;k++)x[n+2][k]=0.0;
  for(k=1;k<=n;k++)
     {for(i=1;i<=n+1;i++)
         {x[n+2][k]+=x[i][k];}
      x[n+2][k]-=x[h][k];
      x[n+2][k]/=((double)n);
     }
  x[n+2][0]=f( &(x[n+2][1]) );
 /*x[l] keresese*/
 for(i=1;i<=n+2;i++)
       {x[i][0]=f( &(x[i][1]) );}
    l=1;
    for(i=1;i<=n+2;i++)
       {if( x[i][0]<x[l][0] )l=i;}
 /*hibabecsles: x[l] koruli gomb sugara, amiben minden x[i] benne van*/
 hiba=0.0;
 for(i=1;i<=n+2;i++)
    {t2=0;
     for(k=1;k<=n;k++)t2+=(x[l][k]-x[i][k])*(x[l][k]-x[i][k]);
     if(t2>hiba)hiba=t2;
    }
 hiba=sqrt(hiba);
 for(k=1;k<=n;k++)minhely[k-1]=x[l][k];
 return hiba;
}

/***********************/
/*memoria felszabaditas*/
/***********************/
void closemin()
{int i;
 for(i=1;i<=n+6;i++)free(x[i]);
 free(x);
}

/**********************************/
/*4th order Runge-Kutta method    */
/*numerically integrates y'=f(y,t)*/
/*y and y' have n elements        */
/**********************************/
#define MAX_FINE_LEVEL 5
#define FINE_CRIT_COS 0.9

/***************************************/
/*creates an rk_t structure            */
/*return: NULL on error                */
/*   pointer to the new rk_t on success*/
/***************************************/
rk_t* rk_create(int dimension)
{rk_t *rk;

 rk=(rk_t*)malloc(sizeof(rk_t));
  if(!rk){return NULL;}
 rk->y=(double*)malloc(sizeof(double)*dimension);
  if(!rk->y)
    {free(rk);
     return NULL;
    }
 rk->k1=(double*)malloc(sizeof(double)*dimension);
  if(!rk->k1)
    {free(rk->y);
     free(rk);
     return NULL;
    }
 rk->k2=(double*)malloc(sizeof(double)*dimension);
  if(!rk->k2)
    {free(rk->k1);
     free(rk->y);
     free(rk);
     return NULL;
    }
 rk->k3=(double*)malloc(sizeof(double)*dimension);
  if(!rk->k3)
    {free(rk->k2);
     free(rk->k1);
     free(rk->y);
     free(rk);
     return NULL;
    }
 rk->k4=(double*)malloc(sizeof(double)*dimension);
  if(!rk->k4)
    {free(rk->k3);
     free(rk->k2);
     free(rk->k1);
     free(rk->y);
     free(rk);
     return NULL;
    }
 rk->finey=(double*)malloc(sizeof(double)*dimension);
  if(!rk->finey)
    {free(rk->k4);
     free(rk->k3);
     free(rk->k2);
     free(rk->k1);
     free(rk->y);
     free(rk);
     return NULL;
    }
 
 rk->n=dimension;
 rk->f=NULL;
 return rk;
}

/***************************************/
/*removes from memory an rk_t structure*/
/***************************************/
void rk_destroy(rk_t *rk)
{
 free(rk->finey);
 free(rk->k4);
 free(rk->k3);
 free(rk->k2);
 free(rk->k1);
 free(rk->y);
 free(rk);
}

/****************************/
/*get and set the f function*/
/****************************/
rk_f rk_get_function(rk_t *rk)
{return rk->f;
}

void rk_set_function(rk_t *rk, rk_f new_function)
{rk->f=new_function;
}

/*********************************/
/*one iteration step             */
/*yn=y(tn), tn is the actual time*/
/*dt is the time step            */
/*return: ynp1=y(tn+dt), and     */
/*zero on success, !=0 on error  */
/*********************************/
int rk_iteration(rk_t *rk, double *yn, double tn, double dt, double *ynp1)
{int i;

 i=rk->f(yn,tn,rk->k1);
  if(i){return i;}
 for(i=0;i<rk->n;i++)
    {rk->k1[i]*=dt;
     rk->y[i]=yn[i]+rk->k1[i]*0.5;
    }
 i=rk->f(rk->y,tn+dt*0.5,rk->k2);
  if(i){return i;}
 for(i=0;i<rk->n;i++)
    {rk->k2[i]*=dt;
     rk->y[i]=yn[i]+rk->k2[i]*0.5;
    }
 i=rk->f(rk->y,tn+dt*0.5,rk->k3);
  if(i){return i;}
 for(i=0;i<rk->n;i++)
    {rk->k3[i]*=dt;
     rk->y[i]=yn[i]+rk->k3[i];
    }
 i=rk->f(rk->y,tn+dt,rk->k4);
  if(i){return i;}
 for(i=0;i<rk->n;i++)
    {rk->k4[i]*=dt;
     ynp1[i]=yn[i]+(rk->k1[i]+2*rk->k2[i]+2*rk->k3[i]+rk->k4[i])/6.0;
    }
 return 0;
}

int finestep_needed(rk_t *rk, double *yn, double tn, double dt, double *ynp)
{int i;
 double cosfi, n1, n2;
 
 i=rk->f(yn, tn, rk->k1);
  if(i){return 0;}
 i=rk->f(ynp, tn+dt, rk->k2);
  if(i){return 0;}
 cosfi=0.0;
 n1=0.0;
 n2=0.0;
 for(i=0;i<rk->n;i++)
    {cosfi+=rk->k1[i]*rk->k2[i];
     n1+=rk->k1[i]*rk->k1[i];
     n2+=rk->k2[i]*rk->k2[i];
    }
 if(n1<EPSILON)
   {return 1;}
 else if(n2/n1>100.0)
        {return 1;}
 if(n2<EPSILON)
   {return 1;}
 else if(n1/n2>100.0)
        {return 1;}
 cosfi=cosfi/(sqrt(n1)*sqrt(n2));
 return (cosfi<FINE_CRIT_COS);
}

int rk_iteration_finestep(rk_t *rk, double *yn, double tn, double dt, double *ynp1)
{double calct, reqt, adt, act;
 int i,j, fine_level;
 
 fine_level=0;
 reqt=fabs(dt);
 calct=0.0;
 adt=dt;
 i=rk_iteration(rk, yn, tn, dt, ynp1);
  if(i){return i;}
 if(finestep_needed(rk, yn, tn, dt, ynp1))
   {for(i=0;i<rk->n;i++)
       {rk->finey[i]=yn[i];
       }
    act=tn;
    while(calct<reqt)
       {while( (finestep_needed(rk, rk->finey, act, adt, ynp1)) 
               && (fine_level<MAX_FINE_LEVEL) )
           {adt/=10.0;
            fine_level++;
            i=rk_iteration(rk, rk->finey, act, adt, ynp1);
             if(i){return i;}
           }
        calct+=fabs(adt);
        act+=adt;
        for(i=0;i<rk->n;i++){rk->finey[i]=ynp1[i];}
        for(j=0;j<9;j++)
           {i=rk_iteration(rk, rk->finey, act, adt, ynp1);
             if(i){return i;}
            calct+=fabs(adt);
            act+=adt;
            for(i=0;i<rk->n;i++){rk->finey[i]=ynp1[i];}
           }
        adt*=10.0;
        fine_level--;
       }
     printf("DEBUG: calct=%g\n",calct);
   }
 return 0;
}
