/*
  PhasePictor - A program for displaying phaseplane of an ODE
  Copyright (c) 2007-2009 Kristóf Kály-Kullai
  This program is free software, it is distributed under the terms 
  of the GNU General Public License version 3 or (at your option) later.
  For details see the attached GPL-3.txt file.
  The software is provided "AS IS", WITHOUT WARRANTY of any kind.
*/
#if !defined(kparser)
 #define kparser
#include<stdio.h>

#define MAX_COMMENT 256
#define MAX_WHITESPACE 256
#define MAX_TOKEN 256

/*********************/
/*initializes kparser*/
/*********************/
void init_kparser();

/**********************************************/
/*Adds c to the set of comment characters.    */
/*Lines started with one of them are comments.*/
/*There are maximum 256 comment characters.   */
/*Return: 0 on success, -1 on error           */
/**********************************************/
int add_comment_character(char c);

/**********************************************/
/*Removes c from the set of comment characters*/
/*Return: 0 on success, -1 on error           */
/**********************************************/
int remove_comment_character(char c);

/**********************************************/
/*Adds c to the set of whitespace characters. */
/*There are maximum 256 whitespace characters.*/
/*Return: 0 on success, -1 on error           */
/**********************************************/
int add_whitespace_character(char c);

/**************************************************/
/*Removes c from the set of whitespace characters.*/
/*Return: 0 on success, -1 on error               */
/**************************************************/
int remove_whitespace_character(char c);

/************************************************************/
/*Reads the next non-comment line from infile to str.       */
/*reads maximum bufsize characters, str should be big enough*/
/*Return: 0 on success, -1 on error                         */
/************************************************************/
int nextline(FILE *infile, char *str, int bufsize);

/********************************************************/
/*Parses str to tokens limited by whitespace characters.*/
/*Return: the number of tokens, or -1 on error.         */
/*In str all whitespace characters are replaced with \0.*/
/********************************************************/
int pars_string(char *str, int bufsize);

/*************************************************/
/*Returns with a pointer to the ith token in str,*/
/*or NULL in case of error.                      */
/*Use after a successful pars_string() call.     */
/*************************************************/
char *get_token(int i);

#endif
