/*
  PhasePictor - A program for displaying phaseplane of an ODE
  Copyright (c) 2007-2009 Kristóf Kály-Kullai
  This program is free software, it is distributed under the terms 
  of the GNU General Public License version 3 or (at your option) later.
  For details see the attached GPL-3.txt file.
  The software is provided "AS IS", WITHOUT WARRANTY of any kind.
*/
#include "kparser.h"

char comment[MAX_COMMENT], whitespace[MAX_WHITESPACE];
char *tokens[MAX_TOKEN];
int num_com, num_wsp, num_tok;

/*********************/
/*initializes kparser*/
/*********************/
void init_kparser()
{int i;
 
 for(i=0;i<MAX_COMMENT;i++)
    {comment[i]=0;}
 num_com=0;
 for(i=0;i<MAX_WHITESPACE;i++)
    {whitespace[i]=0;}
 num_wsp=0;
 for(i=0;i<MAX_TOKEN;i++)
    {tokens[i]=NULL;}
 num_tok=0;
}

/**********************************************/
/*Adds c to the set of comment characters.    */
/*Lines started with one of them are comments.*/
/*There are maximum 256 comment characters.   */
/*Return: 0 on success, -1 on error           */
/**********************************************/
int add_comment_character(char c)
{
 if(num_com>=256){return -1;}
 comment[num_com]=c;
 num_com++;
 return 0;
}

/**********************************************/
/*Removes c from the set of comment characters*/
/*Return: 0 on success, -1 on error           */
/**********************************************/
int remove_comment_character(char c)
{int i, j;
 
 if(num_com<=0){return -1;}
 for(i=0;i<MAX_WHITESPACE;i++)
    {if(comment[i]==c)
       {for(j=i;j<MAX_COMMENT-1;j++)
           {comment[j]=comment[j+1];}
        break;
       }
    }
 num_com--;
 return 0;
}

/**********************************************/
/*Adds c to the set of whitespace characters. */
/*There are maximum 256 whitespace characters.*/
/*Return: 0 on success, -1 on error           */
/**********************************************/
int add_whitespace_character(char c)
{
 if(num_wsp>=256){return -1;}
 whitespace[num_wsp]=c;
 num_wsp++;
 return 0;
}

/**************************************************/
/*Removes c from the set of whitespace characters.*/
/*Return: 0 on success, -1 on error               */
/**************************************************/
int remove_whitespace_character(char c)
{int i,j;
 
 if(num_wsp<=0){return -1;}
 for(i=0;i<MAX_WHITESPACE;i++)
    {if(whitespace[i]==c)
       {for(j=i;j<MAX_WHITESPACE-1;j++)
           {whitespace[j]=whitespace[j+1];}
        break;
       }
    }
 num_wsp--;
 return 0;
}

/************************************************************/
/*Reads the next non-comment line from infile to str.       */
/*reads maximum bufsize characters, str should be big enough*/
/*Return: 0 on success, -1 on error                         */
/************************************************************/
int nextline(FILE *infile, char *str, int bufsize)
{int i, is_comment;

 if( (infile==NULL)||(str==NULL) ){return -1;}
 is_comment=1;
 while(is_comment)
    {if( fgets(str, bufsize, infile) == NULL ){return -1;}
     is_comment=0;
     for(i=0;i<num_com;i++)
        {if(comment[i]==str[0])
           {is_comment=1;
            break;
           }
        }
    }
 return 0;
}

/********************************************************/
/*Parses str to tokens limited by whitespace characters.*/
/*Return: the number of tokens, or -1 on error.         */
/*In str all whitespace characters are replaced with \0.*/
/********************************************************/
int pars_string(char *str, int bufsize)
{int i,j;
 
 if(str==NULL){return -1;}
 /*delete old data*/
 for(i=0;i<num_tok;i++)
    {tokens[i]=NULL;}
 num_tok=0;
 /*parse new str*/
 i=0;
 while(i<bufsize)
    {/*scan whitespaces*/
     for(;i<bufsize;i++)
        {if(str[i]==0){return num_tok;}
         for(j=0;j<num_wsp;j++)
            {if(whitespace[j]==str[i])
               {str[i]=0;
                break;
               }
            }
         /*next non-whitespace character*/
         if(j==num_wsp)
           {tokens[num_tok]=str+i;
            num_tok++;
            break;
           }
        }
     /*scan next token*/
     for(;i<bufsize;i++)
        {if(str[i]==0){return num_tok;}
         for(j=0;j<num_wsp;j++)
            {if(whitespace[j]==str[i]){break;}
            }
         if(j<num_wsp){break;}
        }
    }
 return num_tok;
}

/*************************************************/
/*Returns with a pointer to the ith token in str,*/
/*or NULL in case of error.                      */
/*Use after a successful pars_string() call.     */
/*************************************************/
char *get_token(int i)
{
 if( (i<0)||(i>=num_tok) ){return NULL;}
 return tokens[i];
}
